<?php
/* --------------------------------------------------------------
   CustomerGender.php 2020-01-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Models;

use InvalidArgumentException;
use Webmozart\Assert\Assert;

/**
 * Class CustomerGender
 *
 * @package Gambio\Admin\Withdrawal\Models
 */
class CustomerGender
{
    public const MALE    = 'm';
    public const FEMALE  = 'f';
    public const DIVERSE = 'd';
    
    /**
     * @var string
     */
    private $value;
    
    
    /**
     * CustomerGender constructor.
     *
     * @param string $value
     */
    private function __construct(string $value)
    {
        $this->value = $value;
    }
    
    
    /**
     * Creates a new CustomerGender instance.
     *
     * @param string $value
     *
     * @return CustomerGender
     *
     * @throws InvalidArgumentException
     */
    public static function create(string $value): CustomerGender
    {
        $validValues = [
            self::MALE,
            self::FEMALE,
            self::DIVERSE,
        ];
        
        Assert::oneOf($value,
                      $validValues,
                      'Gender needs to be one of: ' . implode(', ', $validValues) . '; Got: %s');
        
        return new self($value);
    }
    
    
    /**
     * Returns the value of the gender.
     *
     * @return string
     */
    public function value(): string
    {
        return $this->value;
    }
}